import org.apache.cactus.FilterTestCase; 
import org.apache.cactus.WebRequest; 
import org.apache.cactus.client.authentication.*; 

public class TestSecurityFilter extends FilterTestCase { 

	 private SecurityFilter filter; 
	 private MyFilterChain myChain; 

	 public TestSecurityFilter(String name) { 
		super(name); 
	 } 

	 public void setUp() { 
		this.filter = new SecurityFilter(); 
		this.myChain = new MyFilterChain(); 
	 } 
	 // nastavme BASIC autentifikciu 
	 public void beginAuthenticatedUser(WebRequest webRequest) { 
		webRequest.setRedirectorName("SecureFilterRedirector"); 
		webRequest.setAuthentication(new BasicAuthentication("interval","secure")); 
	 } 
	 // otestujeme situciu, ke klient je autentifikovan 
	 public void testAuthenticatedUser() throws Exception { 
		this.myChain.setExpectedInvocation(true); 
		this.filter.doFilter(this.request,this.response,this.myChain); 
		this.myChain.verify(); 
	} 
	 // otestujeme situciu, ke klient nie je autentifikovan 
	 public void testNonAuthenticatedUser() throws Exception { 
		this.myChain.setExpectedInvocation(false); 
		this.filter.doFilter(this.request,this.response,this.myChain); 
		this.myChain.verify(); 
	 } 
}