import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ServletFilter extends HttpServlet {

 public void doGet(HttpServletRequest req, HttpServletResponse res) 
							              throws ServletException, IOException { 

  	String contentType = req.getContentType();
	if (contentType == null) return;
	res.setContentType(contentType);
	PrintWriter out = res.getWriter();
	BufferedReader in = req.getReader();

	String line = null;
	while ((line = in.readLine()) != null) {
		line = replace(line, "<plaintext>", "");
		line = replace(line, "</plaintext>", "");
		out.println(line);
	}
 }
 
 public void doPost(HttpServletRequest req, HttpServletResponse res) 
							              throws ServletException, IOException { 
  doGet(req, res);
 }

 private String replace(String line, String oldString, String newString) {
 	 int index = 0;
	 while ((index = line.indexOf(oldString, index)) >= 0) {
		  // star reazec nahradme novm
		  line = line.substring(0, index) + newString + line.substring(index + oldString.length());
		  index += newString.length();
	 }
	 return line;
 }
}