import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

import com.oroinc.text.perl.*;

public class ServletFilterPerl extends HttpServlet {

  /* Vytvorme objekt Perl5Util, potrebn na vytvorenie 
  regulrneho vrazu, porovnvanie a nahrdzanie reazcov */
  Perl5Util perl = new Perl5Util();

  public void doGet(HttpServletRequest req, HttpServletResponse res)
                               		throws ServletException, IOException {

    String contentType = req.getContentType();
    if (contentType == null) return;
    res.setContentType(contentType);

    PrintWriter out = res.getWriter();

    BufferedReader in = req.getReader();

    try {
      String line = null;
      while ((line = in.readLine()) != null) {
	  	// porovnme a ak je vsledok true nahradme
        if (perl.match("#</?plaintext>#i", line))
          line = perl.substitute("s#</?plaintext>##ig", line);
        out.println(line);
      }
    }
    catch(MalformedPerl5PatternException e) {
      log("Problem with regular expresion: " + e.getMessage());
    }
  }

  public void doPost(HttpServletRequest req, HttpServletResponse res)
                                	throws ServletException, IOException {
    doGet(req, res);
  }
}