import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

import java.util.regex.*;

public class ServletFilterRegEx extends HttpServlet {

  /* Vytvorme objekt predstavujci n regulrny vraz,
  s ktorm budeme potom porovnva. Vytvorme ho tak, aby
  nebol case-sensitive. */
  Pattern pat = Pattern.compile("</?plaintext>", Pattern.CASE_INSENSITIVE);
  /* Vytvorme zatia przdnu referenciu na objekt Matcher, 
  pomocou ktorho budeme porovnva a nahrdza reazce. */
  Matcher mat = null;

  public void doGet(HttpServletRequest req, HttpServletResponse res)
	                               throws ServletException, IOException {

    String contentType = req.getContentType();
    if (contentType == null) return;
    res.setContentType(contentType);
    PrintWriter out = res.getWriter();
    BufferedReader in = req.getReader();

    try {
      String line = null;
      while ((line = in.readLine()) != null) {
	  	/* Objektu Matcher predme odkaz na reazec, ktor 
		budeme porovnva s regulrnym vrazom */
	  	mat = pat.matcher(line);
		/* Metda matches() vrti true ak predan reazec 
		spa podmienky regulrneho vrazu */
		if (mat.matches())
          line = mat.replaceAll("");
        out.println(line);
      }
    }
    catch(PatternSyntaxException e) {
      log("Problem with regular expresion: " + e.getMessage());
    }
  }

  public void doPost(HttpServletRequest req, HttpServletResponse res)
                                	throws ServletException, IOException {
    doGet(req, res);
  }
}